#define IEEE_NOFFSETS	8

class IeeeSource;

class IeeeSymTab : public SymTab {
protected:
	long		offsets[IEEE_NOFFSETS];
	unsigned char	*fcur;
	unsigned char	*fend;
	unsigned char	*fstart;

	void	freeblock();
	void	funcinfo(IeeeSource*,Var**);
	Block	*gatherfunc(Func*);
	Var	*gatherutype(UType*);
	void	gathervar(char*,long,Var**,Block*,UDisc,IeeeSource* =0,int =0);
	char	*gethdr();
	int	getint();
	char	*getstring();
	char	*globals(Var**);
	int	lgetc();
	int	lineinfo(IeeeSource**);
	void	lungetc();
	char	*readblock(long,int);
	void	skipblock();
	void	skipentry();
	void	skipint(int);
	Source	*tree();
	void	typeinfo(IeeeSource*);
public:
		IeeeSymTab(Core*,int,SymTab* =0,long=0);
		~IeeeSymTab();
};

struct IeeeLineEntry {
	int	lineno;
	long	addr;
};

class IeeeSource : public Source {
	friend		IeeeSymTab;
protected:
	int		typecnt;
	DType		*typeinfo;
	int		linecnt;
	IeeeLineEntry	*lineinfo;
	int		sindex;
	DType		chain(DType*);
	DType		gettype(int);
public:
			IeeeSource(SymTab*,Source*,char*,long);
			~IeeeSource();
};
